/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model.fluid;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_2350;
import net.minecraft.class_3518;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import slimeknights.mantle.client.model.util.ModelHelper;
import slimeknights.mantle.util.JsonHelper;

public class FluidCuboid {
    protected static final Map<class_2350, FluidFace> DEFAULT_FACES = new EnumMap<class_2350, FluidFace>(class_2350.class);
    private final Vector3f from;
    private final Vector3f to;
    private final Map<class_2350, FluidFace> faces;
    @Nullable
    private Vector3f fromScaled;
    @Nullable
    private Vector3f toScaled;

    public FluidCuboid(Vector3f from, Vector3f to, Map<class_2350, FluidFace> faces) {
        this.from = from;
        this.to = to;
        this.faces = faces;
    }

    @Nullable
    public FluidFace getFace(class_2350 face) {
        return this.faces.get(face);
    }

    public Vector3f getFromScaled() {
        if (this.fromScaled == null) {
            this.fromScaled = new Vector3f((Vector3fc)this.from);
            this.fromScaled.mul(0.0625f);
        }
        return this.fromScaled;
    }

    public Vector3f getToScaled() {
        if (this.toScaled == null) {
            this.toScaled = new Vector3f((Vector3fc)this.to);
            this.toScaled.mul(0.0625f);
        }
        return this.toScaled;
    }

    public static FluidCuboid fromJson(JsonObject json) {
        Vector3f from = ModelHelper.arrayToVector(json, "from");
        Vector3f to = ModelHelper.arrayToVector(json, "to");
        Map<class_2350, FluidFace> faces = FluidCuboid.getFaces(json);
        return new FluidCuboid(from, to, faces);
    }

    public static List<FluidCuboid> listFromJson(JsonObject parent, String key) {
        JsonElement json = parent.get(key);
        if (json.isJsonObject()) {
            return Collections.singletonList(FluidCuboid.fromJson(json.getAsJsonObject()));
        }
        if (json.isJsonArray()) {
            return JsonHelper.parseList(json.getAsJsonArray(), key, FluidCuboid::fromJson);
        }
        throw new JsonSyntaxException("Invalid fluid '" + key + "', must be an array or an object");
    }

    protected static Map<class_2350, FluidFace> getFaces(JsonObject json) {
        if (!json.has("faces")) {
            return DEFAULT_FACES;
        }
        EnumMap<class_2350, FluidFace> faces = new EnumMap<class_2350, FluidFace>(class_2350.class);
        JsonObject object = class_3518.method_15296((JsonObject)json, (String)"faces");
        for (Map.Entry entry : object.entrySet()) {
            String name = (String)entry.getKey();
            class_2350 dir = class_2350.method_10168((String)name);
            if (dir != null) {
                JsonObject face = class_3518.method_15295((JsonElement)((JsonElement)entry.getValue()), (String)name);
                boolean flowing = class_3518.method_15258((JsonObject)face, (String)"flowing", (boolean)false);
                int rotation = ModelHelper.getRotation(face, "rotation");
                faces.put(dir, new FluidFace(flowing, rotation));
                continue;
            }
            throw new JsonSyntaxException("Unknown face '" + name + "'");
        }
        return faces;
    }

    public Vector3f getFrom() {
        return this.from;
    }

    public Vector3f getTo() {
        return this.to;
    }

    public Map<class_2350, FluidFace> getFaces() {
        return this.faces;
    }

    static {
        for (class_2350 direction : class_2350.values()) {
            DEFAULT_FACES.put(direction, FluidFace.NORMAL);
        }
    }

    public record FluidFace(boolean isFlowing, int rotation) {
        public static final FluidFace NORMAL = new FluidFace(false, 0);
    }
}

